/* - FrequencyCounter full -
 * This example demonstrates the basic usage of a Phidget FrequencyCounter.  It
 * demonstrates the manipulation of the enabled state, filters, timeout, count, time and frequency,
 * as well as displays the data from generated events.
 *
 * Please note that this example was designed to work with only one Phidget
 * Frequency Counter connected.
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package FrequencyCounter;

import com.phidgets.FrequencyCounterPhidget;
import com.phidgets.PhidgetException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import listeners.FCAttachListener;
import listeners.FCCountListener;
import listeners.FCDetachListener;
import listeners.FCErrorListener;

public class FrequencyCounter extends javax.swing.JFrame {

    private static String runArgs[];
    private FrequencyCounterPhidget fc;
    private Hashtable filterTypeHashTable;
    private FCAttachListener attach_listener;
    private FCDetachListener detach_listener;
    private FCErrorListener error_listener;
    private FCCountListener count_listener;

    public FrequencyCounter() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        attachedTxt = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        nameTxt = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        serialTxt = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        versionTxt = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        numChannelsTxt = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        frequencyPanel = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        channelCmb = new javax.swing.JComboBox();
        enableChk = new javax.swing.JCheckBox();
        filterCmb = new javax.swing.JComboBox();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        timeoutTxt = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        countTxt = new javax.swing.JTextField();
        jLabel10 = new javax.swing.JLabel();
        timeTxt = new javax.swing.JTextField();
        jLabel11 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        frequencyTxt = new javax.swing.JTextField();
        totalCountTxt = new javax.swing.JTextField();
        totalTimeTxt = new javax.swing.JTextField();
        setTimeoutBtn = new javax.swing.JButton();
        resetTotalTimeAndCountBtn = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("FrequencyCounter-full");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });
        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Frequency Counter Info"));
        jPanel1.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        attachedTxt.setEditable(false);
        jPanel1.add(attachedTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 33, 200, -1));

        jLabel1.setText("Attached:");
        jPanel1.add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(43, 36, -1, -1));

        nameTxt.setBackground(javax.swing.UIManager.getDefaults().getColor("TextField.disabledBackground"));
        nameTxt.setColumns(20);
        nameTxt.setEditable(false);
        nameTxt.setLineWrap(true);
        nameTxt.setRows(3);
        nameTxt.setTabSize(2);
        nameTxt.setWrapStyleWord(true);
        nameTxt.setPreferredSize(new java.awt.Dimension(200, 58));
        jScrollPane1.setViewportView(nameTxt);

        jPanel1.add(jScrollPane1, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 68, 200, -1));

        jLabel2.setText("Name:");
        jPanel1.add(jLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(60, 68, -1, -1));

        serialTxt.setEditable(false);
        jPanel1.add(serialTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 144, 200, -1));

        jLabel3.setText("Serial No:");
        jPanel1.add(jLabel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(41, 147, -1, -1));

        versionTxt.setEditable(false);
        jPanel1.add(versionTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 180, 200, -1));

        jLabel4.setText("Version:");
        jPanel1.add(jLabel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(48, 180, -1, -1));

        numChannelsTxt.setEditable(false);
        jPanel1.add(numChannelsTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 216, 200, -1));

        jLabel5.setText("# Channels:");
        jPanel1.add(jLabel5, new org.netbeans.lib.awtextra.AbsoluteConstraints(30, 220, -1, 20));

        getContentPane().add(jPanel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 10, 320, 252));

        frequencyPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Frequency Info"));
        frequencyPanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jLabel6.setText("Choose Channel:");
        frequencyPanel.add(jLabel6, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 36, -1, -1));

        channelCmb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                channelCmbActionPerformed(evt);
            }
        });
        frequencyPanel.add(channelCmb, new org.netbeans.lib.awtextra.AbsoluteConstraints(110, 33, 190, -1));

        enableChk.setText("Enabled");
        enableChk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enableChkActionPerformed(evt);
            }
        });
        frequencyPanel.add(enableChk, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 70, -1, -1));

        filterCmb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                filterCmbActionPerformed(evt);
            }
        });
        frequencyPanel.add(filterCmb, new org.netbeans.lib.awtextra.AbsoluteConstraints(150, 72, 150, -1));

        jLabel7.setText("Filter:");
        frequencyPanel.add(jLabel7, new org.netbeans.lib.awtextra.AbsoluteConstraints(112, 75, -1, -1));

        jLabel8.setText("Timeout(ms):");
        frequencyPanel.add(jLabel8, new org.netbeans.lib.awtextra.AbsoluteConstraints(28, 113, -1, -1));

        timeoutTxt.setEditable(false);
        frequencyPanel.add(timeoutTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(105, 110, 105, -1));

        jLabel9.setText("Count Events");
        frequencyPanel.add(jLabel9, new org.netbeans.lib.awtextra.AbsoluteConstraints(21, 150, -1, -1));

        countTxt.setEditable(false);
        frequencyPanel.add(countTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 170, 70, -1));

        jLabel10.setText("pulses in ");
        frequencyPanel.add(jLabel10, new org.netbeans.lib.awtextra.AbsoluteConstraints(125, 173, -1, -1));

        timeTxt.setEditable(false);
        frequencyPanel.add(timeTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(180, 170, 90, -1));

        jLabel11.setText("ms");
        frequencyPanel.add(jLabel11, new org.netbeans.lib.awtextra.AbsoluteConstraints(280, 173, -1, -1));

        jLabel12.setText("Frequency(Hz):");
        frequencyPanel.add(jLabel12, new org.netbeans.lib.awtextra.AbsoluteConstraints(19, 213, -1, -1));

        jLabel13.setText("Total Count:");
        frequencyPanel.add(jLabel13, new org.netbeans.lib.awtextra.AbsoluteConstraints(33, 253, -1, -1));

        jLabel14.setText("Total Time(ms):");
        frequencyPanel.add(jLabel14, new org.netbeans.lib.awtextra.AbsoluteConstraints(19, 293, -1, -1));

        frequencyTxt.setEditable(false);
        frequencyPanel.add(frequencyTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(110, 210, 187, -1));

        totalCountTxt.setEditable(false);
        frequencyPanel.add(totalCountTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(110, 250, 187, -1));

        totalTimeTxt.setEditable(false);
        frequencyPanel.add(totalTimeTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(110, 290, 187, -1));

        setTimeoutBtn.setText("setTimeout");
        setTimeoutBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                setTimeoutBtnActionPerformed(evt);
            }
        });
        frequencyPanel.add(setTimeoutBtn, new org.netbeans.lib.awtextra.AbsoluteConstraints(215, 109, -1, -1));

        resetTotalTimeAndCountBtn.setText("reset Total Count and Total Time");
        resetTotalTimeAndCountBtn.setAlignmentY(0.0F);
        resetTotalTimeAndCountBtn.setMargin(new java.awt.Insets(2, 4, 2, 4));
        resetTotalTimeAndCountBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                resetTotalTimeAndCountBtnActionPerformed(evt);
            }
        });
        frequencyPanel.add(resetTotalTimeAndCountBtn, new org.netbeans.lib.awtextra.AbsoluteConstraints(55, 325, 210, -1));

        getContentPane().add(frequencyPanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 263, 320, 360));

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened

        this.setSize(357, 311);

        attachedTxt.setText("false");
        frequencyPanel.setVisible(false);
        frequencyPanel.setEnabled(false);

        channelCmb.setVisible(false);
        channelCmb.setEnabled(false);
        filterCmb.setVisible(false);
        filterCmb.setEnabled(false);

        filterTypeHashTable = new Hashtable();

        filterTypeHashTable.put("Zero-Crossing", FrequencyCounterPhidget.PHIDGET_FREQUENCYCOUNTER_FILTERTYPE_ZERO_CROSSING);
        filterTypeHashTable.put("Logic-Level", FrequencyCounterPhidget.PHIDGET_FREQUENCYCOUNTER_FILTERTYPE_LOGIC_LEVEL);

        enableChk.setVisible(false);
        enableChk.setEnabled(false);

        timeoutTxt.setVisible(false);
        timeoutTxt.setEnabled(false);
        setTimeoutBtn.setEnabled(false);
        setTimeoutBtn.setVisible(false);

        countTxt.setVisible(false);
        countTxt.setEnabled(false);
        timeTxt.setVisible(false);
        timeTxt.setEnabled(false);

        frequencyTxt.setVisible(false);
        frequencyTxt.setEnabled(false);
        totalCountTxt.setVisible(false);
        totalCountTxt.setEnabled(false);
        totalTimeTxt.setVisible(false);
        totalTimeTxt.setEnabled(false);

        resetTotalTimeAndCountBtn.setEnabled(false);
        resetTotalTimeAndCountBtn.setVisible(false);

        try {
            fc = new FrequencyCounterPhidget();

            attach_listener = new FCAttachListener(this, this.frequencyPanel, this.channelCmb, this.filterCmb, this.filterTypeHashTable, this.attachedTxt, this.nameTxt,
                    this.serialTxt, this.versionTxt, this.numChannelsTxt, this.enableChk, this.timeoutTxt, this.setTimeoutBtn, this.countTxt, this.timeTxt,
                    this.frequencyTxt, this.totalCountTxt, this.totalTimeTxt, this.resetTotalTimeAndCountBtn);

            detach_listener = new FCDetachListener(this, this.frequencyPanel, this.channelCmb, this.filterCmb, this.attachedTxt, this.nameTxt,
                    this.serialTxt, this.versionTxt, this.numChannelsTxt, this.enableChk, this.timeoutTxt, this.setTimeoutBtn, this.countTxt, this.timeTxt,
                    this.frequencyTxt, this.totalCountTxt, this.totalTimeTxt, this.resetTotalTimeAndCountBtn);

            error_listener = new FCErrorListener(this);

            count_listener = new FCCountListener(this.channelCmb, this.countTxt, this.timeTxt, this.frequencyTxt, this.totalCountTxt, this.totalTimeTxt);

            fc.addAttachListener(attach_listener);
            fc.addDetachListener(detach_listener);
            fc.addErrorListener(error_listener);
            fc.addFrequencyCounterCountListener(count_listener);

            //This assumes that if there is a command line argument, it is a serial number
            //and we try to open that specific device. Otherwise, open any device.
            if ((runArgs.length > 1) && (runArgs[1].equals("remote"))) {
                fc.open(Integer.parseInt(runArgs[0]), null);
            }
            if (runArgs.length > 0) {
                fc.open(Integer.parseInt(runArgs[0]));
            } else {
                fc.openAny();
            }

        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_formWindowOpened

    private void channelCmbActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_channelCmbActionPerformed
  
        reset();
        try {
            if (fc.isAttached() && fc.getEnabled(((Integer) channelCmb.getSelectedItem()).intValue())) {
                enableChk.setSelected(true);
                filterCmb.setEnabled(true);
                setFilterCmb();
                setTimeoutBtn.setEnabled(true);
                timeoutTxt.setEditable(true);
                timeoutTxt.setText(Integer.toString(fc.getTimeout((((Integer) channelCmb.getSelectedItem()).intValue())) / 1000));
                resetTotalTimeAndCountBtn.setEnabled(true);
            } else {
                enableChk.setSelected(false);
                timeoutTxt.setEditable(false);
                setTimeoutBtn.setEnabled(false);
                filterCmb.setEnabled(false);
                resetTotalTimeAndCountBtn.setEnabled(false);
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_channelCmbActionPerformed

    private void filterCmbActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_filterCmbActionPerformed
     
        reset();
       
        int index = ((Integer) channelCmb.getSelectedItem()).intValue();
        try {
            if (fc.isAttached() && fc.getEnabled(index)) {
                int value = ((Integer) filterTypeHashTable.get(filterCmb.getSelectedItem())).intValue();
                fc.setFilter(index, value);
                timeoutTxt.setText(Integer.toString(fc.getTimeout((((Integer) channelCmb.getSelectedItem()).intValue())) / 1000));
            } else {
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_filterCmbActionPerformed

    private void setTimeoutBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_setTimeoutBtnActionPerformed
        try {
            fc.setTimeout(((Integer) channelCmb.getSelectedItem()).intValue(), Integer.parseInt(timeoutTxt.getText()) * 1000);
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_setTimeoutBtnActionPerformed

    private void enableChkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enableChkActionPerformed
        reset();
        try {
            fc.setEnabled(((Integer) channelCmb.getSelectedItem()).intValue(), enableChk.isSelected());
            if (enableChk.isSelected()) {
                filterCmb.setEnabled(true);
                setFilterCmb();
                setTimeoutBtn.setEnabled(true);
                timeoutTxt.setEditable(true);
                timeoutTxt.setText(Integer.toString(fc.getTimeout(((Integer) channelCmb.getSelectedItem()).intValue()) / 1000));
                resetTotalTimeAndCountBtn.setEnabled(true);
            } else {
                filterCmb.setEnabled(false);
                timeoutTxt.setEditable(false);
                setTimeoutBtn.setEnabled(false);
                resetTotalTimeAndCountBtn.setEnabled(false);
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_enableChkActionPerformed

    private void resetTotalTimeAndCountBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_resetTotalTimeAndCountBtnActionPerformed
            try {
            fc.reset(((Integer) channelCmb.getSelectedItem()).intValue());
            timeTxt.setText("");
            countTxt.setText("");
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_resetTotalTimeAndCountBtnActionPerformed

    private void setFilterCmb() {
        int index = ((Integer) channelCmb.getSelectedItem()).intValue();
        Enumeration eKeys = filterTypeHashTable.keys();
        int element;
        try {
            element = fc.getFilter(index);

            while (eKeys.hasMoreElements()) {
                Object currKey = eKeys.nextElement();
                if (((Integer) filterTypeHashTable.get(currKey)).intValue() == element) {
                    filterCmb.setSelectedItem(currKey);
                }
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }

    private void reset() {
        timeoutTxt.setText("");
        countTxt.setText("");
        timeTxt.setText("");
        frequencyTxt.setText("");
        totalCountTxt.setText("");
        totalTimeTxt.setText("");
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        runArgs = args;
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new FrequencyCounter().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField attachedTxt;
    private javax.swing.JComboBox channelCmb;
    private javax.swing.JTextField countTxt;
    private javax.swing.JCheckBox enableChk;
    private javax.swing.JComboBox filterCmb;
    private javax.swing.JPanel frequencyPanel;
    private javax.swing.JTextField frequencyTxt;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea nameTxt;
    private javax.swing.JTextField numChannelsTxt;
    private javax.swing.JButton resetTotalTimeAndCountBtn;
    private javax.swing.JTextField serialTxt;
    private javax.swing.JButton setTimeoutBtn;
    private javax.swing.JTextField timeTxt;
    private javax.swing.JTextField timeoutTxt;
    private javax.swing.JTextField totalCountTxt;
    private javax.swing.JTextField totalTimeTxt;
    private javax.swing.JTextField versionTxt;
    // End of variables declaration//GEN-END:variables
}
